<?php
/**
* @package plugin Offline
* @copyright (C) 2010-2011 RicheyWeb - www.richeyweb.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Offline Copyright (c) 2011 Michael Richey.
* Offline is licensed under the http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
*/
// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

/**
 * Offline system plugin
 */
class plgSystemOffline extends JPlugin
{
    public $offline;
    public $admin;
    function __construct(&$subject, $config = array()) {
        parent::__construct($subject, $config);
        $app = JFactory::getApplication();
        $this->offline = $app->getCfg('offline');
        $this->admin = $app->isAdmin();
    }
    function onAfterInitialise()
    {
        if($this->admin) return true;
        if(!$this->offline) return true;
        if(JFactory::getUser()->id) {
            $this->_online();
            return true;
        }
	require_once('classes/helper.php');
	$whitelist = json_decode($this->params->get('whitelist','{}'),JSON_OBJECT_AS_ARRAY);
	if(count($whitelist)) {
	    require_once('classes/simplecidr.class.php');
	    $gmp = false;
	    if(OfflineHelper::_testGMP()) {
		require_once('classes/IPv6Net.class.php');
		$gmp = true;
	    }
	    $ip = OfflineHelper::_getIP();	    
	    foreach($whitelist['ipaddress'] as $item) {
		if(OfflineHelper::_isIPv6($item)) {
		    if(OfflineHelper::_testIPv6($ip,$item,$gmp)) {
			$this->_online();
			return true;			    
		    }
		    continue;
		}
		if(OfflineHelper::_testIPv4($ip,$item)) {
		    $this->_online();
		    return true;			    
		}	
	    }
	}
        $app = JFactory::getApplication();
        $input = $app->input;       
        if($input->cookie->get('online',false) === $this->params->get('key','true')) {
            $this->_online();
            return true;
        }
        if($input->get->get('online',false)) {
            if($input->get->get('online',false) === $this->params->get('key','true')) {
                $this->_authorize();
                $this->_online();
                return true;
            }
        }
    }
    function _online(){
        $config = JFactory::getConfig();
        $config->set('offline',0);   
    }
    function _authorize(){
        $config = JFactory::getConfig();
        $input = JFactory::getApplication()->input;
        $input->cookie->set('online',$this->params->get('key','true'),0,$config->get('cookie_path'),$config->get('cookie_domain'),false,true);
    }
}