<?php
defined('JPATH_BASE') or die;

class OfflineHelper {
    static function _testIPv6($ip,$item,$gmp) {
	if(self::_isCIDR($item) && $gmp) {
	    $net = new Offline\IPv6Net($item);
	    if($net->contains($ip)) {
		return true;
	    }
	    return false;
	}
	return ($ip === $item);
    }
    static function _testIPv4($ip,$item) {
	if(self::_isCIDR($item)) {
	    $net = Offline\SimpleCIDR::getInstance($item);
	    if($net->contains($ip)) {
		return true;
	    }
	    return false;
	}
	return (long2ip(ip2long($ip)) === long2ip(ip2long($item)));
    }
    static function _testGMP() { 
	$servergmp = get_extension_funcs('gmp')?:array();
        $gmpfuncs = array(
            'gmp_init','gmp_setbit','gmp_strval','gmp_testbit',
            'gmp_cmp','gmp_intval','gmp_add','gmp_neg','gmp_mul',
            'gmp_sub','gmp_pow','gmp_scan0','gmp_and','gmp_or');
        return array_intersect($gmpfuncs,$servergmp) == $gmpfuncs;
    }
    static function _getIP() {	
	$ip = getenv('HTTP_CLIENT_IP')?:
	getenv('HTTP_X_FORWARDED_FOR')?:
	getenv('HTTP_X_FORWARDED')?:
	getenv('HTTP_FORWARDED_FOR')?:
	getenv('HTTP_FORWARDED')?:
	getenv('REMOTE_ADDR');
	return $ip;
    }
    static function _isCIDR($item) {
	if(strpos($item,'/') !== false) {
	    return true;
	}
	return false;
    }
    static function _isIPv6($ip) {
	if(strpos($ip, ":") !== false && strpos($ip, ".") === false) {
	    return true;
	}
	return false;
    }
}