<?php

/**
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2018 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

// No direct access to this file
defined('_JEXEC') or die;

JFormHelper::loadFieldClass('text');

use Joomla\Registry\Registry;

class JFormFieldNRResponsiveControl extends JFormFieldText
{
    /**
     *  Method to render the input field
     *
     *  @return  string  
     */
    function getInput()
    {
        return $this->getLayout();
    }

    /**
     * Returns html for all devices
     * 
     * @return  array
     */
    private function getFieldsData()
    {
        if (!$fieldsList = $this->getSubformFieldsList())
        {
            return [];
        }
        
        $html = [
            'desktop' => '',
            'tablet'  => '',
            'mobile'  => ''
        ];

        $base_name = $fieldsList['base_name'];

        // loop for all devices
        foreach ($html as $key => $value)
        {
            $device_output = '';

            // loop all fields
            foreach ($fieldsList['fields'] as $fieldName)
            {
                $name = $fieldName;

                $field_data = $this->getFieldInputByDevice($name, $key);
                $field_html = $field_data['html'];

                $field_html = str_replace(
                    [
                        '[' . $this->group . '][' . $name . ']',
                        '_' . $this->group . '_' . $name
                    ],
                    [
                        '[' . $this->group . '][' . $base_name . '][' . $name . '][' . $key . ']',
                        '_' . $this->group . '_' . $base_name . '_' . $name . '_' . $key
                    ], $field_html
                );
                
                // Render layout
                $payload = [
                    'label' => $field_data['label'],
                    'data' => $field_html
                ];
                $layout = new JLayoutFile('responsive_control_item', JPATH_PLUGINS . '/system/nrframework/layouts');
                $device_output .= $layout->render($payload);
            }

            $html[$key] = $device_output;

        }
        
        return $html;
    }

    /**
     * Returns the field layout
     * 
     * @return  string
     */
    private function getLayout()
    {
        JHtml::stylesheet('plg_system_nrframework/responsive_control.css', ['relative' => true, 'version' => 'auto']);
        JHtml::script('plg_system_nrframework/responsive_control.js', ['relative' => true, 'version' => 'auto']);

        $width = isset($this->element['width']) ? (string) $this->element['width'] : '300px';
        $title = isset($this->element['title']) ? (string) $this->element['title'] : '';
        $class = isset($this->element['class']) ? ' ' . (string) $this->element['class'] : '';

        if (defined('nrJ4'))
        {
            $class .= ' isJ4';
        }
        
        $data = [
            'title'  => JText::_($title),
            'width'  => $width,
            'class'  => $class,
            'fields' => $this->getFieldsData()
        ];

        // Render layout
        $layout = new JLayoutFile('responsive_control', JPATH_PLUGINS . '/system/nrframework/layouts');
        return $layout->render($data);
    }

    /**
     * Returns the list of added fields
     * 
     * @return  array
     */
    private function getSubformFieldsList()
    {
        $el = $this->element;

        if (empty(count($el->subform)))
        {
            return [];
        }

        $data = [
            'base_name' => $el->attributes()->name,
            'fields' => []
        ];

        foreach ($el->subform->field as $key => $field)
        {
            $data['fields'][] = (string) $field->attributes()->name;
        }
        
        return $data;
    }

    /**
     * Returns the field's title and value
     * 
     * @param   string  $field_name
     * @param   string  $device
     * 
     * @return  array
     */
    private function getFieldInputByDevice($field_name, $device)
    {
        $el = $this->element;

        $data = [];

        foreach ($el->subform->field as $key => $field)
        {
            $name = $field->attributes()->name;

            if ($name != $field_name)
            {
                continue;
            }

            $data = [
                'label' => JText::_($field->attributes()->label),
                'html' => $this->form->getInput($name, $this->group, $this->getFieldInputValue($field_name, $device))
            ];
        }

        return $data;
    }

    /**
     * Finds the field input value
     * 
     * @param   string  $field_name
     * @param   string  $device
     * 
     * @return  string
     */
    private function getFieldInputValue($field_name, $device)
    {
        $values = $this->getValue();
        $values = new Registry($values);

        return $values->get($field_name . '.' . $device);
    }

    /**
     * Returns the field value
     * 
     * @return  mixed
     */
    private function getValue()
    {
        if (empty($this->value))
        {
            return;
        }

        return $this->value;
    }
}
